library(scales)
inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure S4 - seed loss/'
setwd(inputDirectory)

initialSeedNumber = 350

d = read.csv('Individual-specific harvest.csv')
d$biomass.g = 0.006397113*(d$area.cm2^1.145345)
d$biomass.mg = d$biomass.g*1000

# Range of values for the proportion of seeds recruited per pot:
range(tapply(d$area.cm2, d$pot.ID, length))/initialSeedNumber * 100

d$pot.ID = factor(d$pot.ID)
d$lense = factor(d$lense, levels = c('hollow', 'flat', 'hummock'))
levels(d$lense) = c('Lowered','Flat','Raised')
d$inundation.percent = factor(d$inundation.percent, levels = c('50','35','20'))
d$drainage = factor(d$drainage, levels = c('no drainage', 'drainage'))

totalRecruits = as.numeric(tapply(d$biomass.mg,d$pot.ID, length))
lense = factor(levels(d$lense)[tapply(d$lense, d$pot.ID, unique)], levels = levels(d$lense))
inundFreq = factor(levels(d$inundation.percent)[tapply(d$inundation.percent, d$pot.ID, unique)])
vertDrainage = factor(levels(d$drainage)[tapply(d$drainage, d$pot.ID, unique)])

plotDirectory = '/Users/gfivash/Desktop/'
setwd(plotDirectory)
tiff("Figure S4.tif",width = 5, height = 6, units = 'in', res = 300)

colSeq = c('yellow','green','blue')
par(mfrow = c(1,1))
boxplot(totalRecruits ~ lense, col = alpha(colSeq,0.5), notch = T, ylim = c(0, initialSeedNumber), pch = '', 
     ylab = 'Recruit number', xlab =' Sediment shape')
points(totalRecruits ~ jitter(as.numeric(lense),factor = 0.2), pch = 21, bg = alpha(colSeq[lense],0.5))
lines(x = c(0,4), y = c(initialSeedNumber,initialSeedNumber), lwd = 2, lty = 2)
text(x = 1, y = 335, 'Initial seed input')
text(x = 1:3, y = 225, c('A','B','C'))
dev.off()

m = aov(totalRecruits ~ lense)
anova(m)
TukeyHSD(m)
